<?php
/**
 * SEO测试插件
 * 
 * @package SEOHTML
 * @author 小夜
 * @version 1.0.1
 * @dependence 9.9.2-*
 * @link http://www.vpsmm.com
 *
 *
 */
class seohtml_Plugin implements Typecho_Plugin_Interface
{
    /**
     * 激活插件方法,如果激活失败,直接抛出异常
     * 
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function activate()
    {
		Helper::addRoute('index_page', '/[page:digital].html', 'Widget_Archive', 'render');
		Helper::addRoute('attachment', '/attachment-[cid:digital].html', 'Widget_Archive', 'render');
		Helper::removeRoute('category');
		Helper::addRoute('category', '/category-[slug].html', 'Widget_Archive', 'render');
		Helper::removeRoute('category_page');
		Helper::addRoute('category_page', '/category-[slug]-[page:digital].html', 'Widget_Archive', 'render');
		Helper::removeRoute('tag');
		Helper::addRoute('tag', '/tag-[slug].html', 'Widget_Archive', 'render');
		Helper::removeRoute('tag_page');
		Helper::addRoute('tag_page', '/tag-[slug]-[page:digital].html', 'Widget_Archive', 'render');
		Helper::removeRoute('search');
		Helper::addRoute('search', '/search-[keywords].html', 'Widget_Archive', 'render');
		Helper::removeRoute('search_page');
		Helper::addRoute('search_page', '/searchpage-[keywords]-[page:digital].html', 'Widget_Archive', 'render');
		Helper::removeRoute('author');
		Helper::addRoute('author', '/author-[uid:digital].html', 'Widget_Archive', 'render');
		Helper::removeRoute('author_page');
		Helper::addRoute('author_page', '/author-[uid:digital]-[page:digital].html', 'Widget_Archive', 'render');		
    }
    
    /**
     * 禁用插件方法,如果禁用失败,直接抛出异常
     * 
     * @static
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function deactivate()
	{
	}
    
    /**
     * 获取插件配置面板
     * 
     * @access public
     * @param Typecho_Widget_Helper_Form $form 配置面板
     * @return void
     */
    public static function config(Typecho_Widget_Helper_Form $form){}
    
    /**
     * 个人用户的配置面板
     * 
     * @access public
     * @param Typecho_Widget_Helper_Form $form
     * @return void
     */
    public static function personalConfig(Typecho_Widget_Helper_Form $form){}

}
