# TypechoPDF

一个简单而强大的Typecho PDF阅读器插件，可以直接在文章页面中嵌入PDF查看器。

## 功能特点

- 自动识别文章中的PDF链接
- 将PDF链接转换为内嵌的PDF阅读器
- 支持自定义阅读器的宽度和高度
- 响应式设计，自适应不同屏幕大小
- 支持中英文界面切换
- 支持PDF文件上下滚动浏览
- 支持缩放、页面跳转等功能
- 基于PDF.js，提供完整的PDF阅读体验

## 插件设置

在Typecho后台插件设置中，您可以：

1. 设置PDF阅读器的宽度
   - 支持百分比（如：100%）
   - 支持像素值（如：800px）

2. 设置PDF阅读器的高度
   - 建议使用像素值（如：600px）

3. 选择界面语言
   - 中文（zh-CN）
   - English（en-US）

## 性能优化建议

1. PDF文件建议进行压缩处理，以提高加载速度
2. 大文件（>10MB）建议使用云存储服务
3. 建议开启服务器缓存
4. 可以考虑使用CDN加速PDF.js的静态资源

## 注意事项

1. 确保服务器允许跨域请求，否则可能无法加载PDF文件
2. PDF文件需要能够通过URL直接访问
3. 注意服务器的文件上传大小限制
4. 建议将较大的PDF文件存储在云存储服务中

## 常见问题

1. PDF无法显示
   - 检查PDF文件URL是否可以直接访问
   - 检查服务器是否允许跨域请求
   - 检查浏览器控制台是否有错误信息

2. 显示空白
   - 检查PDF文件是否损坏
   - 检查PDF文件大小是否过大
   - 尝试刷新页面或清除浏览器缓存

3. 加载速度慢
   - 建议压缩PDF文件
   - 考虑使用云存储或CDN
   - 检查服务器带宽是否足够

## 更新日志

### v1.0.0
- 初始版本发布
- 支持PDF文件在线预览
- 支持中英文界面切换
- 支持自定义查看器尺寸

## 技术支持

如果您在使用过程中遇到任何问题，请通过以下方式获取帮助：

1. 在GitHub上提交Issue
2. 通过插件主页留言

## 作者

- 作者：flyhunterl
- 博客：[https://llingfei.com](https://llingfei.com)

## 开源协议

本插件采用MIT协议开源。

## 致谢

- [PDF.js](https://mozilla.github.io/pdf.js/) - Mozilla提供的PDF渲染引擎
- [Typecho](http://typecho.org/) - 优雅的开源博客程序

![3f89fd9d8711f1d165cf91de2994435](https://github.com/user-attachments/assets/c2585baa-b4eb-4fe5-9814-27a367e523d7)

