<?php
/**
 * 全局替换页面中的链接，使用CDN等
 *
 * @package URLReplace
 * @author 懵仙兔兔
 * @version 1.1
 * @update 2020-03-27
 * @link https://2dph.com
 */
class URLReplace_Plugin implements Typecho_Plugin_Interface
{
    /**
     * 激活插件方法,如果激活失败,直接抛出异常
     *
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function activate()
    {
        #Typecho_Plugin::factory('Widget_Abstract_Contents')->contentEx = array('URLReplace_Plugin', 'url_replace');

        //在end这里处理,可以处理field中的url
        Typecho_Plugin::factory('index.php')->end = array('URLReplace_Plugin', 'url_replace_and_echo');



    }

    /**
     * 禁用插件方法,如果禁用失败,直接抛出异常
     *
     * @static
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function deactivate(){}

    /**
     * 获取插件配置面板
     *
     * @access public
     * @param Typecho_Widget_Helper_Form $form 配置面板
     * @return void
     */
    public static function config(Typecho_Widget_Helper_Form $form){

        $rule_1 = new Typecho_Widget_Helper_Form_Element_Text('rule_1', null, 'replace_from=>replace_to', _t('规则一'), _t('替换规则：以“=>”分割，全局使用正则表达式'));
        $form->addInput($rule_1);

        $rule_2 = new Typecho_Widget_Helper_Form_Element_Text('rule_2', null, 'replace_from=>replace_to', _t('规则二'), _t('替换规则：以“=>”分割，全局使用正则表达式'));
        $form->addInput($rule_2);

        $rule_3 = new Typecho_Widget_Helper_Form_Element_Text('rule_3', null, 'replace_from=>replace_to', _t('规则三'), _t('替换规则：以“=>”分割，全局使用正则表达式'));
        $form->addInput($rule_3);

        $rule_4 = new Typecho_Widget_Helper_Form_Element_Text('rule_4', null, 'replace_from=>replace_to', _t('规则四'), _t('替换规则：以“=>”分割，全局使用正则表达式'));
        $form->addInput($rule_4);

        $rule_5 = new Typecho_Widget_Helper_Form_Element_Text('rule_5', null, 'replace_from=>replace_to', _t('规则五'), _t('替换规则：以“=>”分割，全局使用正则表达式'));
        $form->addInput($rule_5);

        $rule_6 = new Typecho_Widget_Helper_Form_Element_Text('rule_6', null, 'replace_from=>replace_to', _t('规则六'), _t('替换规则：以“=>”分割，全局使用正则表达式'));
        $form->addInput($rule_6);

        $rule_7 = new Typecho_Widget_Helper_Form_Element_Text('rule_7', null, 'replace_from=>replace_to', _t('规则七'), _t('替换规则：以“=>”分割，全局使用正则表达式'));
        $form->addInput($rule_7);

        $rule_8 = new Typecho_Widget_Helper_Form_Element_Text('rule_8', null, 'replace_from=>replace_to', _t('规则八'), _t('替换规则：以“=>”分割，全局使用正则表达式'));
        $form->addInput($rule_8);

        $rule_9 = new Typecho_Widget_Helper_Form_Element_Text('rule_9', null, 'replace_from=>replace_to', _t('规则九'), _t('替换规则：以“=>”分割，全局使用正则表达式'));
        $form->addInput($rule_9);

        $rule_10 = new Typecho_Widget_Helper_Form_Element_Text('rule_10', null, 'replace_from=>replace_to', _t('规则十'), _t('替换规则：以“=>”分割，全局使用正则表达式'));
        $form->addInput($rule_10);

        $rule_11 = new Typecho_Widget_Helper_Form_Element_Text('rule_11', null, 'replace_from=>replace_to', _t('规则十一'), _t('替换规则：以“=>”分割，全局使用正则表达式'));
        $form->addInput($rule_11);

        $rule_12 = new Typecho_Widget_Helper_Form_Element_Text('rule_12', null, 'replace_from=>replace_to', _t('规则十二'), _t('替换规则：以“=>”分割，全局使用正则表达式'));
        $form->addInput($rule_12);

        $rule_13 = new Typecho_Widget_Helper_Form_Element_Text('rule_13', null, 'replace_from=>replace_to', _t('规则十三'), _t('替换规则：以“=>”分割，全局使用正则表达式'));
        $form->addInput($rule_13);

        $rule_14 = new Typecho_Widget_Helper_Form_Element_Text('rule_14', null, 'replace_from=>replace_to', _t('规则十四'), _t('替换规则：以“=>”分割，全局使用正则表达式'));
        $form->addInput($rule_14);

        $rule_15 = new Typecho_Widget_Helper_Form_Element_Text('rule_15', null, 'replace_from=>replace_to', _t('规则十五'), _t('替换规则：以“=>”分割，全局使用正则表达式'));
        $form->addInput($rule_15);

        $rule_16 = new Typecho_Widget_Helper_Form_Element_Text('rule_16', null, 'replace_from=>replace_to', _t('规则十六'), _t('替换规则：以“=>”分割，全局使用正则表达式'));
        $form->addInput($rule_16);

        $rule_17 = new Typecho_Widget_Helper_Form_Element_Text('rule_17', null, 'replace_from=>replace_to', _t('规则十七'), _t('替换规则：以“=>”分割，全局使用正则表达式'));
        $form->addInput($rule_17);

        $rule_18 = new Typecho_Widget_Helper_Form_Element_Text('rule_18', null, 'replace_from=>replace_to', _t('规则十八'), _t('替换规则：以“=>”分割，全局使用正则表达式'));
        $form->addInput($rule_18);

        $rule_19 = new Typecho_Widget_Helper_Form_Element_Text('rule_19', null, 'replace_from=>replace_to', _t('规则十九'), _t('替换规则：以“=>”分割，全局使用正则表达式'));
        $form->addInput($rule_19);

        $rule_20 = new Typecho_Widget_Helper_Form_Element_Text('rule_20', null, 'replace_from=>replace_to', _t('规则二十'), _t('替换规则：以“=>”分割，全局使用正则表达式'));
        $form->addInput($rule_20);

    }

    /**
     * 个人用户的配置面板
     *
     * @access public
     * @param Typecho_Widget_Helper_Form $form
     * @return void
     */
    public static function personalConfig(Typecho_Widget_Helper_Form $form){}




    public static function url_replace($content, $opt)
    {
        $config = Helper::options()->plugin('URLReplace');

        $rules=array();
        $rules[] = $config->rule_1;
        $rules[] = $config->rule_2;
        $rules[] = $config->rule_3;
        $rules[] = $config->rule_4;
        $rules[] = $config->rule_5;
        $rules[] = $config->rule_6;
        $rules[] = $config->rule_7;
        $rules[] = $config->rule_8;
        $rules[] = $config->rule_9;
        $rules[] = $config->rule_10;
        $rules[] = $config->rule_11;
        $rules[] = $config->rule_12;
        $rules[] = $config->rule_13;
        $rules[] = $config->rule_14;
        $rules[] = $config->rule_15;
        $rules[] = $config->rule_16;
        $rules[] = $config->rule_17;
        $rules[] = $config->rule_18;
        $rules[] = $config->rule_19;
        $rules[] = $config->rule_20;

        foreach ($rules as $rule){
            if(!empty($rule)){
                $tmp = explode('=>', $rule);
                if(count($tmp) != 2){
                    # 格式不正确,跳过
                    continue;
                }
                $from = trim($tmp[0]);
                $to = trim($tmp[1]);
                if($from == 'replace_from'){
                    # 默认字符串,跳过
                    continue;
                }
                $content = preg_replace($from,$to,$content);
            }
        }
        return $content;
    }

    public static function url_replace_and_echo(){
        $output = ob_get_contents();
        ob_end_clean();

        $result = self::url_replace($output, null);
        echo $result;
    }

}