<?php
/**
 *时序图
 * 
 * @package SequenceDiagram 
 * @author ZhangZijing(Venteto)
 * @version 1.2.0
 * @link https://v.meloduet.com
 */
class SequenceDiagram_Plugin implements Typecho_Plugin_Interface {
     /**
     * 激活插件方法,如果激活失败,直接抛出异常
     * 
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function activate() {
        Typecho_Plugin::factory('Widget_Archive')->header = array(__CLASS__, 'header');       
    }

    /**
     * 禁用插件方法,如果禁用失败,直接抛出异常
     * 
     * @static
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function deactivate(){}

    /**
     * 获取插件配置面板
     * 
     * @access public
     * @param Typecho_Widget_Helper_Form $form 配置面板
     * @return void
     */
    public static function config(Typecho_Widget_Helper_Form $form){

		$importJquery = new Typecho_Widget_Helper_Form_Element_Radio('importJquery', array(
            0   =>  _t('否'),
            1   =>  _t('是')
        ), 1, _t('引入jQuery'), _t('本插件需要jQuery, 如果你的网站没有自带jQuery, 请选择"是"'));
        $form->addInput($importJquery->addRule('enum', _t('请选择一个'), array(0, 1)));

         $reverse = new Typecho_Widget_Helper_Form_Element_Radio('reverse', array(
            0   =>  _t('否'),
            1   =>  _t('是')
        ), 0, _t('反转颜色'), _t('用于暗色主题'));
        $form->addInput($reverse->addRule('enum', _t('请选择一种'), array(0, 1)));

    }

    /**
     * 个人用户的配置面板
     * 
     * @access public
     * @param Typecho_Widget_Helper_Form $form
     * @return void
     */
    public static function personalConfig(Typecho_Widget_Helper_Form $form){}

    /**
     * 插件实现方法
     * 
     * @access public
     * @return void
     */
    public static function render() {
        
    }

   
    /**
     * 判断是否是内容页，避免主页加载插件
     */
    public static function is_content() {
        static $is_content = null;
        if($is_content === null) {
            $widget = Typecho_Widget::widget('Widget_Archive');
            $is_content = !($widget->is('index') || $widget->is('search') || $widget->is('date') || $widget->is('category') || $widget->is('author'));
        }
        return $is_content;
    }
 

    /**
     *为header添加css文件
     *@return void
     */
    public static function header() {
        /*if (!self::is_content()) {
            return;
        }*/

		if (Helper::options()->plugin('SequenceDiagram')->importJquery) {
            echo '<script src="https://cdn.bootcss.com/jquery/3.3.1/jquery.min.js"></script>';
        }
        $js4 = Helper::options()->pluginUrl . '/SequenceDiagram/sequence-diagram-min.js';
        $js2 = Helper::options()->pluginUrl . '/SequenceDiagram/snap.svg-min.js';
        $js3 = Helper::options()->pluginUrl . '/SequenceDiagram/underscore-min.js';
        $js1 = Helper::options()->pluginUrl . '/SequenceDiagram/webfont.js';
        if (Helper::options()->plugin('SequenceDiagram')->reverse) {
                    $css = Helper::options()->pluginUrl . '/SequenceDiagram/sequence-diagram-dark.css';
                    echo '<link rel="stylesheet" type="text/css" href="'.$css.'" />';
        }
         echo <<<HTML
         
<script type="text/javascript" src="$js1"></script>
<script type="text/javascript" src="$js2"></script>
<script type="text/javascript" src="$js3"></script>
<script type="text/javascript" src="$js4"></script>

<script>
$(function(){

            var seq_elements = $('code.language-seq,code.lang-seq,code.language-sequence,code.lang-sequence');
            //seq_elements.push($('code .lang-flow'));
            for(var i =0; i<seq_elements.length; i++)
            {
                var seq_element = seq_elements[i];
                var container =document.createElement("div");
                seq_element.parentNode.parentNode.insertBefore(container,seq_element.parentNode);
                var code = seq_element.innerText;

                  var diagram = Diagram.parse(code);
                  diagram.drawSVG(container, {theme: 'simple'});
                    seq_element.parentNode.remove();
            

}});

    </script>


HTML;
        
    }


}
