<?php
/**
 * 支持文件上传的XhEditor编辑器 For Typecho
 * 
 * @package XhEditor 
 * @author ljweb modified by roybit and QISHI
 * @author last modified by QISHI
 * @version 1.0.2
 * @link http://ljweb.com.ru http://www.roybit.com 
 * @link http://www.wuqishi.com
 */
class XhEditor_Plugin implements Typecho_Plugin_Interface
{
    /**
     * 激活插件方法,如果激活失败,直接抛出异常
     * 
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function activate()
    {
        Typecho_Plugin::factory('admin/write-post.php')->richEditor = array('XhEditor_Plugin', 'render');
        Typecho_Plugin::factory('admin/write-page.php')->richEditor = array('XhEditor_Plugin', 'render');
    }
    
    /**
     * 禁用插件方法,如果禁用失败,直接抛出异常
     * 
     * @static
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function deactivate(){}
    
    /**
     * 获取插件配置面板
     * 
     * @access public
     * @param Typecho_Widget_Helper_Form $form 配置面板
     * @return void
     */
    public static function config(Typecho_Widget_Helper_Form $form)
    {
        //*换行符设置
        $xh_forcePtag = new Typecho_Widget_Helper_Form_Element_Select( 'xh_forcePtag' ,
                                                                    array( 'false' => 'BR' , 'true' => 'P' ) ,
                                                                    'false' ,
                                                                    _t('换行符'),
                                                                    _t('回车换行符设置：p,br')
                                                                  );
        $form->addInput($xh_forcePtag);

        //*工具按钮
        $xh_tools = new Typecho_Widget_Helper_Form_Element_Select( 'xh_tools' ,
			array( 'mfull' => '标准模式' ,'Fontface,FontSize,Bold,Italic,Underline,Strikethrough,FontColor,BackColor,Removeformat,|,Align,List,Outdent,Indent,|,Link,Img,Source,Preview,About,More' => '简单模式' ,
			   	'Bold,Italic,Underline,Strikethrough,|,Align,List,|,Link,Img,Source,Preview,About,More' => '迷你模式' ) ,
                                                                    'simple' , 
                                                                    _t('工具按钮'),
                                                                    _t('工具栏按钮设置')
                                                                  );
        $form->addInput($xh_tools);

        //*皮肤设置
        $xh_skin = new Typecho_Widget_Helper_Form_Element_Select( 'xh_skin' ,
                                                                    array( 'default' => '默认皮肤' , 'vista' => 'Vista' ) ,
                                                                    'nostyle' ,
                                                                    _t('皮肤选择'),
                                                                    _t('设置编辑器皮肤')
                                                                  );
        $form->addInput($xh_skin);
    }
    
    /**
     * 个人用户的配置面板
     * 
     * @access public
     * @param Typecho_Widget_Helper_Form $form
     * @return void
     */
    public static function personalConfig(Typecho_Widget_Helper_Form $form){}

    /**
     * 插件实现方法
     * 
     * @access public
     * @return void
     */
    public static function render($post)
    {
        $options = Helper::options();
		$plugin_options = Typecho_Widget::widget('Widget_Options')->plugin('XhEditor');
		$xh_forcePtag = $plugin_options->xh_forcePtag;
		$xh_skin = $plugin_options->xh_skin;
		$xh_tools = $plugin_options->xh_tools;
		$editor_path = Typecho_Common::url('XhEditor/editor', $options->pluginUrl);
		echo "
<script type=\"text/javascript\" charset=\"utf-8\" src=\"{$editor_path}/jquery.js\"></script>
<script type=\"text/javascript\" charset=\"utf-8\" src=\"{$editor_path}/xheditor/xheditor.js\"></script>
<script type=\"text/javascript\">
jQuery.noConflict();
(function($) {
     $(function() {
		 var allPlugin={
			 More:{c:'xheIcon xheMore',t:'更多标签',s:'ctrl+m',e:function(){
				 this.pasteHTML('<!--more-->');
				 }
			 }};
	 var editor=$('#text').xheditor({forcePtag:$xh_forcePtag,skin:'$xh_skin',upLinkUrl:'{$editor_path}/upload.php', upLinkExt:'zip,rar,txt',upImgUrl:'{$editor_path}/upload.php',upImgExt:'jpg,jpeg,gif,png',upFlashUrl:'{$editor_path}/upload.php', upFlashExt:'swf',upMediaUrl:'{$editor_path}/upload.php',upMediaExt:'avi',plugins:allPlugin,tools:'$xh_tools'});
	 $('#btn-submit,#btn-save').mouseover(editor.getSource)
    });
})(jQuery);
</script>";
    }

}
