<?php
/**
 * 关键字高亮插件
 * 
 * @package HightlightTag
 * @author HJin.me
 * @version 1.0.0
 * @link http://hjin.me/projects/
 *
 */
class HightlightTag_Plugin implements Typecho_Plugin_Interface
{
    /**
     * 激活插件方法,如果激活失败,直接抛出异常
     * 
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function activate()
    {    
		Typecho_Plugin::factory('Widget_Abstract_Contents')->contentEx = array('HightlightTag_Plugin', 'hightlight');
		Typecho_Plugin::factory('Widget_Abstract_Contents')->excerptEx = array('HightlightTag_Plugin', 'hightlight');

        return _t('HightlightTag 启用成功');
    }

    /**
     * 禁用插件方法,如果禁用失败,直接抛出异常
     * 
     * @static
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function deactivate(){
    }

    /**
     * 获取插件配置面板
     * 
     * @access public
     * @param Typecho_Widget_Helper_Form $form 配置面板
     * @return void
     */
    public static function config(Typecho_Widget_Helper_Form $form)
    {
        $options = Typecho_Widget::widget('Widget_Options');
        //配置信息
        $hightlightTags = new Typecho_Widget_Helper_Form_Element_Text('hightlightTimes', NULL, 1, _t('高亮标签数量'), _t('同一个标签被高亮次数'));
        $form->addInput($hightlightTags);
    }

    /**
     * 个人用户的配置面板
     * 
     * @access public
     * @param Typecho_Widget_Helper_Form $form
     * @return void
     */
    public static function personalConfig(Typecho_Widget_Helper_Form $form)
    {
    }

    /**
     * 高亮处理器
     * @access public
     * @param string $content 文章正文
     * @param Widget_Abstract_Contents $opt 
     */
    public static function hightlight($content, $opt)
    {
        $options = Typecho_Widget::widget('Widget_Options');
        $config = $options->plugin('HightlightTag');
		$times = $config->hightlightTimes;
		$content = Typecho_Common::lockHTML($content);
		if($time <= 0) $time = 1;
		
		foreach($opt->tags as $tag) {
			//有次数的替换
			$content = preg_replace('/>([^<]*)' . $tag['name'] . '([^>]*)<([^>]*)([^a])>/i','>$1<a href="' . $tag['permalink'] . '" title="' . $tag['name'] . '" class="hightag" target="_blank">' . $tag['name'] . '</a>$2<$3$4>', $content, $times);
		}
		return trim(Typecho_Common::releaseHTML($content));
    }

}