<?php
/**
 * Digg For Typecho
 * 
 * @package Digg
 * @author doudou
 * @version 1.0.0
 * @link http://doudou.me
 * @date 2012-3-12
 */
class Digg_Plugin implements Typecho_Plugin_Interface
{
    /**
     * 激活插件方法,如果激活失败,直接抛出异常
     * 
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function activate()
    {

        $db = Typecho_Db::get();
        $prefix = $db->getPrefix();
        if (!array_key_exists('digg', $db->fetchRow($db->select()->from('table.contents'))))
            $db->query('ALTER TABLE `'. $prefix .'contents` ADD `digg` TEXT DEFAULT NULL;');

        Helper::addAction('Digg', 'Digg_Action');
    }

    /**
     * 禁用插件方法,如果禁用失败,直接抛出异常
     * 
     * @static
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function deactivate()
    {
        Helper::removeAction('Digg');

        $db = Typecho_Db::get();
        $prefix = $db->getPrefix();
        $drop = Helper::options()->plugin('Digg')->drop;
        if ($drop && array_key_exists('digg', $db->fetchRow($db->select()->from('table.contents')))) {
            $db->query('ALTER TABLE `'. $prefix .'contents` DROP `digg`;');
            return('插件已经禁用, 插件数据已经删除');
        } else {
            return('插件已经禁用, 插件数据保留');
        }
    }
    
    /**
     * 获取插件配置面板
     * 
     * @access public
     * @param Typecho_Widget_Helper_Form $form 配置面板
     * @return void
     */
    public static function config(Typecho_Widget_Helper_Form $form)
    {
        $imgurl = new Typecho_Widget_Helper_Form_Element_Text('imgurl', 
        NULL, Helper::options()->pluginUrl . '/Digg/img/',
        _t('表情图片地址'),
        _t('可自定义表情图片地址, 以 <b>/</b> 结尾.'));
        $form->addInput($imgurl->addRule('url', '请填入一个url地址'));

        $items = new Typecho_Widget_Helper_Form_Element_Text('items', 
        NULL, 'zhichi|gaoxing',
        _t('项目存储名'),
        _t('英文或拼音，用 | 分开，如 zhichi|gaoxing，中间不能留有空格且最后字符不为 | <br />每个项目对应的图片为<项目存储名.gif> 例如 zhichi.gif 和 gaoxing.gif'));
        $form->addInput($items);

        $items_echo = new Typecho_Widget_Helper_Form_Element_Text('items_echo', 
        NULL, '支持|高兴',
        _t('项目中文输出'),
        _t('项目存储名的对应输出名字，如 支持|高兴 (必须与上面一一对应，缺项将出错)'));
        $form->addInput($items_echo);

        //兼容旧版本  getPrefix为新增
        $cookie_prefix = (method_exists('Typecho_Cookie','getPrefix') ? Typecho_Cookie::getPrefix():'') . '__typecho_digg_';
        $post_url = Typecho_Common::url('action/Digg', Helper::options()->index);

        $src = new Typecho_Widget_Helper_Form_Element_Textarea('src', 
        NULL, 
"<script type=\"text/javascript\" src=\"http://lib.sinaapp.com/js/jquery/1.2.6/jquery.min.js\"></script>
<script type=\"text/javascript\" src=\"" . Helper::options()->pluginUrl . "/Digg/digg.js\"></script>",
        _t('css 及 javascript'),
        _t("<div style=\"width:450px;padding:10px; background:#DFE5C6; font-size:12px;border-radius:5px;\">本插件需要jQuery，可以在这里引用第三方托管的类库，也可以在这里嵌入css。<br /><span style=\"color:#BD6800\">{$post_url}</span><br /><span style=\"color:#BD6800\">{$cookie_prefix}</span><br>如该域名下有多个Typecho且均使用Digg，请修改插件目录下的digg.js。<br /> 将digg_url 和 digg_cookie_base的值替换成上面的字符串即可。</div>"));
        $form->addInput($src);

        $drop = new Typecho_Widget_Helper_Form_Element_Radio('drop', 
        array(0 => _t('不刪除'), 1 => _t('刪除')),
        0,
        _t('禁用时是否删除数据'),
        _t('若不再使用此插件, 或想清空digg数据, 请选择删除后再禁用.
<div style="width:450px;padding:10px; background:#DFE5C6; font-size:12px;border-radius:5px;">
    <span>1. 建议先测试成功后选择删除数据再禁用，再启用插件并配置</span><br>
    <span>2. digg 项目可随时添加，删除。但如果原来项目为zhichi|gaoxing ，修改成zhichi|happy 后，并不能将gaoxing的digg数转移到happy下，如需要要此类修改，只需修改对应的中文输出即可。</span>
</div>
'));
        $form->addInput($drop);

    }

    /**
     * 个人用户的配置面板
     * 
     * @access public
     * @param Typecho_Widget_Helper_Form $form
     * @return void
     */
    public static function personalConfig(Typecho_Widget_Helper_Form $form){}

    /**
     * 输出方法
     * 
     * @access public
     * @return void or array
     */
    public static function output($return = false, $dump = false)
    {
        //防止未激活插件输出错误信息，可注释掉
        $all = Typecho_Plugin::export();
        if (!array_key_exists('Digg', $all['activated'])) return;

        //获取相关设置
        $setting = Helper::options()->plugin('Digg');
        $imgurl = $setting->imgurl;
        $items = explode("|", $setting->items);
        $items_echo = explode("|", $setting->items_echo);
        $src = $setting->src;
        $post_url = Typecho_Common::url('action/Digg', Helper::options()->index);


        //获取日志digg数据
        $db = Typecho_Db::get();
        $cid = Typecho_Widget::widget('Widget_Archive')->cid;
        $result = $db->fetchRow($db->select('digg')->from('table.contents')->where('cid = ?', $cid));
        $result['digg'] = empty($result['digg']) ? array() : unserialize($result['digg']);

        //输出js及css
        echo $src;

        /* <?php Digg_Plugin::output(); ?> 按插件自定义格式输出 也可自己修改输出格式*/
        if (!$return) {
            echo "<div id=\"digg\" class=\"clearfix\" style=\"text-align:center;\"><ul>";
            foreach ($items as $k => $v) {
                echo "<li id='digg-{$v}' style='float:left;list-style-type: none;'>";
                echo $items_echo[$k] . '<br>';
                echo '<a href="javascript:digg(\'' . $v .'\',\'' . $cid . '\');"><img src="'. $imgurl . $v .'.gif" /></a>';
                $n = array_key_exists($v,$result['digg']) ? $result['digg'][$v] : 0 ;
                echo '<br><span id="' . 'digg-' . $v . '-num">' . $n . '</li>';
            }
            echo '</ul></div>';
            return;
        }

        /* <?php Digg_Plugin::output(true); ?> 将digg数据以数组形式返回，自定义html结构  可外加参数true查看返回数据*/
        $r = array();
        $r['count_times'] = 0;
        foreach ($items as $k => $v) {
            $r['count_items'] = count($items);
            $r['cid'] = $cid;
            $r['items'][$v]['times'] = array_key_exists($v,$result['digg']) ? $result['digg'][$v] : 0 ;
            $r['items'][$v]['echo'] = $items_echo[$k];
            $r['items'][$v]['imgurl'] = $imgurl . $v . '.gif';
            $r['items'][$v]['diggurl'] = $post_url . '?action=' . $v . '&cid=' . $cid;
            $r['count_times'] += $r['items'][$v]['times'];
        }
        if ($dump) var_dump($r);   //var_dump
        return $r;
    }

}
