<?php
/**
 * 使用最新HighSlide全功能内核自动替换图片链接。新增豪华页面相册功能，集成弹窗式评论表情按钮。
 * @package HighSlide
 * @author 羽中
 * @version 1.3.1
 * @link http://www.jzwalk.com/archives/net/highslide-for-typecho
 */
class HighSlide_Plugin implements Typecho_Plugin_Interface
{
    /**
     * 激活插件方法,如果激活失败,直接抛出异常
     *
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function activate()
    {
        Typecho_Plugin::factory('Widget_Archive')->header = array('HighSlide_Plugin', 'headlink');
        Typecho_Plugin::factory('Widget_Archive')->footer = array('HighSlide_Plugin', 'footlink');
        Typecho_Plugin::factory('Widget_Abstract_Contents')->contentEx = array('HighSlide_Plugin', 'highslideclass');
        Typecho_Plugin::factory('Widget_Abstract_Contents')->excerptEx = array('HighSlide_Plugin', 'highslideclass');
        Typecho_Plugin::factory('Widget_Abstract_Contents')->filter = array('HighSlide_Plugin', 'gallerycodes1');
        Typecho_Plugin::factory('Widget_Abstract_Contents')->filter = array('HighSlide_Plugin', 'gallerycodes2');
        Typecho_Plugin::factory('Widget_Abstract_Contents')->filter = array('HighSlide_Plugin', 'gallerycodes3');
        Typecho_Plugin::factory('Widget_Abstract_Contents')->filter = array('HighSlide_Plugin', 'gallerycodes4');
        Typecho_Plugin::factory('Widget_Abstract_Contents')->filter = array('HighSlide_Plugin', 'gallerycodes5');
    }
   
    /**
     * 禁用插件方法,如果禁用失败,直接抛出异常
     *
     * @static
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function deactivate(){
	}
   
    /**
     * 获取插件配置面板
     *
     * @access public
     * @param Typecho_Widget_Helper_Form $form 配置面板
     * @return void
     */
    public static function config(Typecho_Widget_Helper_Form $form){
    $lang = new Typecho_Widget_Helper_Form_Element_Radio('lang',
    array('true'=>_t('中文'),'false'=>_t('英文')),'true',_t('提示语言'));
    $form->addInput($lang->multiMode());
    
    $trans = new Typecho_Widget_Helper_Form_Element_Select('trans',
    array('expand'=>_t('缩放式'),'fade'=>_t('渐变式')),'expand',_t('动画效果'));
    $form->addInput($trans->multiMode());
    
    $align = new Typecho_Widget_Helper_Form_Element_Radio('align',
    array('false'=>_t('自由'),'true'=>_t('居中')),'false',_t('弹框位置'));
    $form->addInput($align->multiMode());
    
    $outline= new Typecho_Widget_Helper_Form_Element_Select('outline',array(''=>_t('无'),'rounded-white'=>_t('清新圆角'),'outer-glow'=>_t('荧光边缘'),'glossy-dark'=>_t('暗黑琉璃')),'rounded-white',_t('边框样式'));
    $form->addInput($outline->multiMode());
    
    $wrap = new Typecho_Widget_Helper_Form_Element_Checkbox('wrap',
    array('wide-border'=>_t('宽边界'),'borderless'=>_t('无边界'),'colored-border'=>_t('绿色边界'),'dark'=>_t('黑色背景 <span style="color:#264409;padding:2px 5px;font-size:12px;background:#D3DBB3;border: 1px solid #aaa;">推荐搭配"暗黑琉璃"</span>'),'outer-glow'=>_t('荧光灰框 <span style="color:#264409;padding:2px 5px;font-size:12px;background:#D3DBB3;border: 1px solid #aaa;">推荐搭配"荧光边缘"</span>'),'floating-caption'=>_t('图片标题悬浮'),'draggable-header'=>_t('顶部可拖拽 <span style="color:#264409;padding:2px 5px;font-size:12px;background:#D3DBB3;border: 1px solid #aaa;">用于html弹窗</span>'),'titlebar'=>_t('标题栏 <span style="color:#264409;padding:2px 5px;font-size:12px;background:#D3DBB3;border: 1px solid #aaa;">用于html弹窗</span>'),'no-footer'=>_t('底部功能去除 <span style="color:#264409;padding:2px 5px;font-size:12px;background:#D3DBB3;border: 1px solid #aaa;">用于html弹窗</span>')),NULL,_t('内层样式'),_t('<span style="color:#E47E00;font-size:12px;font-weight:bold;">搭配边框样式自由组合高级效果。</span>'));
    $form->addInput($wrap->multiMode());
    
    $capt = new Typecho_Widget_Helper_Form_Element_select('capt',
    array(''=>_t('关闭'),'this.a.title'=>_t('开启，使用链接title信息'),'this.thumb.alt'=>_t('开启，使用图片alt信息')),'',_t('图片标题'),_t('<div style="color:#E47E00;font-size:12px;font-weight:bold;">开启后请注意在插入图片代码中写好相关属性。例：</div><div style="color:#264409;padding:2px 5px;font-size:12px;background:#D3DBB3;width:280px;border: 1px solid #aaa;">&#60;a href="http://xx.jpg" title="链接title标题"&#62;&#60;img src="http://x.jpg" alt="图片alt标题"/&#62;&#60;/a&#62;</div>'));
    $form->addInput($capt->multiMode());
    
    $cpos = new Typecho_Widget_Helper_Form_Element_select('cpos',
    array(''=>_t('关闭'),'heading'=>_t('开启，顶部显示'),'caption'=>_t('开启，底部显示')),'',_t('图片序数'));
    $form->addInput($cpos->multiMode());
    
    $opac = new Typecho_Widget_Helper_Form_Element_Text('opac', NULL, '0.75', _t('背投阴影透明度'), _t('<span style="color:#E47E00;font-size:12px;font-weight:bold;">0-1之间的小数，由无到纯黑。</span>'));
    $opac->input->setAttribute('class', 'mini');
    $form->addInput($opac->addRule('isFloat', _t('请填写数字')));
        
    $slide = new Typecho_Widget_Helper_Form_Element_Radio('slide',
    array('true'=>_t('开启'),'false'=>_t('关闭')),'true',_t('幻灯导航面板'));
    $form->addInput($slide->multiMode());
    
    $auto = new Typecho_Widget_Helper_Form_Element_Radio('auto',
    array('true'=>_t('是'),'false'=>_t('否')),'false',_t('鼠标移出自动关闭'));
    $form->addInput($auto->multiMode());
    
    $butn = new Typecho_Widget_Helper_Form_Element_Radio('butn',
    array('true'=>_t('带'),'false'=>_t('不带')),'false',_t('圆形关闭按钮'));
    $form->addInput($butn->multiMode());
    
    $gallery= new Typecho_Widget_Helper_Form_Element_Select('gallery',array('gallery-horizontal-strip'=>_t('连环画册'),'gallery-thumbstrip-above'=>_t('黑色影夹'),'gallery-vertical-strip'=>_t('时光胶带'),'gallery-in-box'=>_t('纯白记忆'),'gallery-floating-thumbs'=>_t('往事片段'),'gallery-floating-caption'=>_t('沉默注脚'),'gallery-controls-in-heading'=>_t('岁月名片'),'gallery-in-page'=>_t('幻影橱窗(单相册)')),'gallery-horizontal-strip',_t('<strong>页面相册样式套装</strong>'),_t('<span style="color:#E6EFC2;font-size:12px;">高级效果套装，独立应用于页面相册。</span>'));
    $form->addInput($gallery->setAttribute('class', 'column-09 typecho-radius-topleft typecho-radius-topright typecho-radius-bottomleft typecho-radius-bottomright')->setAttribute('style', 'font-size:13px;padding:10px;color:#fff;background:#444;position:absolute;top:15px;right:0px;z-index:10;'));
    
    $gallery1 = new Typecho_Widget_Helper_Form_Element_Textarea('gallery1', NULL, "http://www.jzwalk.com/usr/uploads/2010/03/3825439295.jpg;http://www.jzwalk.com/usr/uploads/2010/03/994053445.jpg;相册一演示图1|http://www.jzwalk.com/usr/uploads/2010/03/3690577133.jpg;http://www.jzwalk.com/usr/uploads/2010/03/2478084981.jpg;相册一演示图2|http://www.jzwalk.com/usr/uploads/2010/03/3259807887.jpg;http://www.jzwalk.com/usr/uploads/2010/03/2696132013.jpg;相册一演示图封面",_t('<strong>相册1</strong>'), _t('<span style="color:#E6EFC2;font-size:12px;">每张图片需依次给出<span style="color:#E47E00;">缩略图地址;原图地址;标题文字</span>三项设置，以<span style="color:#E47E00;font-weight:bold">;</span>号分隔。每张图片设置以<span style="color:#E47E00;font-weight:bold">|</span>号分割，最后一张为该相册封面。</span>'));
    $gallery1->input->setAttribute('style', 'width:345px;height:100px;');
    $form->addInput($gallery1->setAttribute('class', 'column-09 typecho-mini-panel typecho-radius-topleft typecho-radius-topright')->setAttribute('style', 'font-size:13px;padding:10px;color:#fff;background:#444;position:absolute;top:72px;right:0px;'));
    
    $gallery2 = new Typecho_Widget_Helper_Form_Element_Textarea('gallery2', NULL, "http://www.jzwalk.com/usr/uploads/2010/03/4060218301.jpg;http://www.jzwalk.com/usr/uploads/2010/03/1079604421.jpg;相册二演示图|http://www.jzwalk.com/usr/uploads/2010/03/4060218301.jpg;http://www.jzwalk.com/usr/uploads/2010/03/589995852.jpg;相册二演示图封面",_t('<strong>相册2</strong>'), _t('<span style="color:#E6EFC2;font-size:12px;">每张图片需依次给出<span style="color:#E47E00;">缩略图地址;原图地址;标题文字</span>三项设置，以<span style="color:#E47E00;font-weight:bold">;</span>号分隔。每张图片设置以<span style="color:#E47E00;font-weight:bold">|</span>号分割，最后一张为该相册封面。</span>'));
    $gallery2->input->setAttribute('style', 'width:345px;height:100px;');
    $form->addInput($gallery2->setAttribute('class', 'column-09')->setAttribute('style', 'font-size:13px;padding:10px;color:#fff;background:#444;position:absolute;top:253px;right:0px;'));
    
    $gallery3 = new Typecho_Widget_Helper_Form_Element_Textarea('gallery3', NULL, "http://www.jzwalk.com/usr/uploads/2010/03/32079078.jpg;http://www.jzwalk.com/usr/uploads/2010/03/3700047134.jpg;相册三演示图",_t('<strong>相册3</strong>'), _t('<span style="color:#E6EFC2;font-size:12px;">每张图片需依次给出<span style="color:#E47E00;">缩略图地址;原图地址;标题文字</span>三项设置，以<span style="color:#E47E00;font-weight:bold">;</span>号分隔。每张图片设置以<span style="color:#E47E00;font-weight:bold">|</span>号分割，最后一张为该相册封面。</span>'));
    $gallery3->input->setAttribute('style', 'width:345px;height:100px;');
    $form->addInput($gallery3->setAttribute('class', 'column-09')->setAttribute('style', 'font-size:13px;padding:10px;color:#fff;background:#444;position:absolute;top:434px;right:0px;'));
    
    $gallery4 = new Typecho_Widget_Helper_Form_Element_Textarea('gallery4', NULL, "http://www.jzwalk.com/usr/uploads/2010/03/2284949816.jpg;http://www.jzwalk.com/usr/uploads/2010/03/862606582.jpg;相册四演示图",_t('<strong>相册4</strong>'), _t('<span style="color:#E6EFC2;font-size:12px;">每张图片需依次给出<span style="color:#E47E00;">缩略图地址;原图地址;标题文字</span>三项设置，以<span style="color:#E47E00;font-weight:bold">;</span>号分隔。每张图片设置以<span style="color:#E47E00;font-weight:bold">|</span>号分割，最后一张为该相册封面。</span>'));
    $gallery4->input->setAttribute('style', 'width:345px;height:100px;');
    $form->addInput($gallery4->setAttribute('class', 'column-09')->setAttribute('style', 'font-size:13px;padding:10px;color:#fff;background:#444;position:absolute;top:615px;right:0px;'));
    
    $gallery5 = new Typecho_Widget_Helper_Form_Element_Textarea('gallery5', NULL, "",_t('<strong>相册5</strong>'), _t('<span style="color:#E6EFC2;font-size:12px;">每张图片需依次给出<span style="color:#E47E00;">缩略图地址;原图地址;标题文字</span>三项设置，以<span style="color:#E47E00;font-weight:bold">;</span>号分隔。每张图片设置以<span style="color:#E47E00;font-weight:bold">|</span>号分割，最后一张为该相册封面。</span>'));
    $gallery5->input->setAttribute('style', 'width:345px;height:100px;');
    $form->addInput($gallery5->setAttribute('class', 'column-09 typecho-radius-bottomleft typecho-radius-bottomright')->setAttribute('style', 'font-size:13px;padding:10px;color:#fff;background:#444;position:absolute;top:796px;right:0px;z-index:10;'));
    echo '<div class="column-09 typecho-mini-panel typecho-radius-topleft typecho-radius-topright typecho-radius-bottomleft typecho-radius-bottomright" style="height:109px;font-size:13px;padding:10px;position:absolute;top:996px;right:0px;z-index:10;">页面中写入<strong>[GALLERY-1] [GALLERY-2] [GALLERY-3] [GALLERY-4] [GALLERY-5]</strong>即可显示对应相册。<div style="font-size:13px;">更多详细使用说明请参阅<a href="'.Helper::options()->pluginUrl .'/HighSlide/'.'Readme.txt" target="_blank">Readme文件</a>。</div><div style="text-align:right;font-size:13px;font-weight:bold;"><a href="http://www.jzwalk.com/archives/net/highslide-for-typecho" target="_blank">插件主页&raquo</a></div><div style="float:right;font-size:12px;margin-top:6px;font-weight:bold;"><span style="color:#E47E00;margin-right:7px;">zyz61@tom.com</span> Paypal/支付宝捐赠支持</div><form action="https://www.paypal.com/cgi-bin/webscr" method="post">
<input type="hidden" name="cmd" value="_s-xclick">
<input type="hidden" name="hosted_button_id" value="Q4H5G6ASET9ZG">
<input type="image" src="https://www.paypal.com/en_GB/i/btn/btn_donate_SM.gif" border="0" name="submit" alt="PayPal - The safer, easier way to pay online.">
<img alt="" border="0" src="https://www.paypal.com/zh_XC/i/scr/pixel.gif" width="1" height="1">
</form></div>';
 }

    /**
     * 个人用户的配置面板
     *
     * @access public
     * @param Typecho_Widget_Helper_Form $form
     * @return void
     */
    public static function personalConfig(Typecho_Widget_Helper_Form $form){}   
   
    /**
     * 自动替换图片链接
     *
     * @access public
     * @param string $content
     * @return void
     */
    public static function highslideclass($content, $widget, $lastResult) {
        $Archive = Typecho_Widget::widget('Widget_Archive');
    	$content = empty($lastResult) ? $content : $lastResult;
    	if ( $widget instanceof Widget_Archive && $Archive->is('index') || $Archive->is('post') || $Archive->is('archive') ) {
    	$pattern = "/<a(.*?)href=('|\")([^>]*).(bmp|gif|jpeg|jpg|png)('|\")(.*?)>(.*?)<\/a>/i";
    	$replacement = '<a$1href=$2$3.$4$5 class="highslide"  onclick="return hs.expand(this,{slideshowGroup:\'images\'})" $6>$7 </a>';
    	$content = preg_replace($pattern, $replacement, $content);
    	}
        return $content;
    }
    
    /**
     * 评论表情按钮
     *
     * @access public
     * @param string $emoticon
     * @return void
     */
    public static function emoticons() {
          $smilies_trans = array(
          ':?:'        => 'icon_question.gif',
          ':razz:'     => 'icon_razz.gif',
          ':sad:'      => 'icon_sad.gif',
          ':evil:'     => 'icon_evil.gif',
          ':!:'        => 'icon_exclaim.gif',
          ':smile:'    => 'icon_smile.gif',
          ':oops:'     => 'icon_redface.gif',
          ':grin:'     => 'icon_biggrin.gif',
          ':eek:'      => 'icon_surprised.gif',
          ':shock:'    => 'icon_eek.gif',
          ':???:'      => 'icon_confused.gif',
          ':cool:'     => 'icon_cool.gif',
          ':lol:'      => 'icon_lol.gif',
          ':mad:'      => 'icon_mad.gif',
          ':twisted:'  => 'icon_twisted.gif',
          ':roll:'     => 'icon_rolleyes.gif',
          ':wink:'     => 'icon_wink.gif',
          ':idea:'     => 'icon_idea.gif',
          ':arrow:'    => 'icon_arrow.gif',
          ':neutral:'  => 'icon_neutral.gif',
          ':cry:'      => 'icon_cry.gif',
          ':mrgreen:'  => 'icon_mrgreen.gif',
          '8-)'        => 'icon_cool.gif',
          '8-O'        => 'icon_eek.gif',
          ':-('        => 'icon_sad.gif',
          ':-)'        => 'icon_smile.gif',
          ':-?'        => 'icon_confused.gif',
          ':-D'        => 'icon_biggrin.gif',
          ':-P'        => 'icon_razz.gif',
          ':-o'        => 'icon_surprised.gif',
          ':-x'        => 'icon_mad.gif',
          ':-|'        => 'icon_neutral.gif',
          ';-)'        => 'icon_wink.gif',
          '8)'         => 'icon_cool.gif',
          '8O'         => 'icon_eek.gif',
          ':('         => 'icon_sad.gif',
          ':)'         => 'icon_smile.gif',
          ':?'         => 'icon_confused.gif',
          ':D'         => 'icon_biggrin.gif',
          ':P'         => 'icon_razz.gif',
          ':o'         => 'icon_surprised.gif',
          ':x'         => 'icon_mad.gif',
          ':|'         => 'icon_neutral.gif',
          ';)'         => 'icon_wink.gif',
          );
    	$Options = Typecho_Widget::widget('Widget_Options');
        $HighSlide_ul = $Options->pluginUrl .'/HighSlide/';
        $Smilies_ul = $Options->pluginUrl .'/Smilies/';
	    $closeAction = 'return hs.close(\'emoticons\');';
	    $emoticons = '';
	    $smiled = array();
	    foreach ($smilies_trans as $tag => $grin) {
		    if ( !in_array($grin, $smiled) ) {
			    $smiled[] = $grin;
			    $tag = str_replace(' ', '', $tag);
			    $emoticons .= '<img style="margin:2px;cursor:pointer;" onclick="insertEmoticon(\' '.$tag.' \');' . $closeAction . '" src="'.$Smilies_ul.'img/'.$grin.'" alt="'.$tag.'"/>';
		    }
	    }
        // 弹框输出
	    $emoticon = '<script type="text/javascript" src="'.$HighSlide_ul.'emoticons.js"></script>';
	    $emoticon .= '<span style="cursor:pointer;" title="' . _t('选择表情') . '" onclick="return hs.htmlExpand(this, { contentId: \'emoticons\' } )" class="HighSlide">';
	    $emoticon .= '<img src="'.$Smilies_ul.'img/icon_smile.gif" alt="emoticons" />';
	    $emoticon .= '</span>';
	    $emoticon .= '<div class="highslide-html-content" id="emoticons" style="width:200px;">';
	    $emoticon .= '<div class="highslide-body">';
	    $emoticon .= $emoticons;
	    $emoticon .= '</div>';
	    $emoticon .= '<div class="highslide-header">';
	    $emoticon .= '<ul>';
	    $emoticon .= '<li class="highslide-close"><span style="cursor:pointer;" onclick="return hs.close(this)">' . _t('关闭') . '</span></li>';
	    $emoticon .= '</ul>';
	    $emoticon .= '</div>';
	    $emoticon .= '</div>';

	    echo $emoticon;
	}

    /**
     * 头部样式
     *
     * @access public
     * @param unknown $headlink
     * @return unknown
     */
    public static function headlink($cssUrl) {
        $Settings = Helper::options()->plugin('HighSlide');
        $Archive = Typecho_Widget::widget('Widget_Archive');
        $HighSlide_ul = Helper::options()->pluginUrl .'/HighSlide/';
        $cssUrl = '<link rel="stylesheet" type="text/css" href="'.$HighSlide_ul.'highslide.css" />
<!--[if lt IE 7]>
<link rel="stylesheet" type="text/css" href="'.$HighSlide_ul.'highslide-ie6.css" />
<![endif]-->
';
        if ( $Archive->is('page') ) {
        	if ( $Settings->gallery == 'gallery-in-page' ) {
        	$cssUrl.= '<style type="text/css">
.highslide-image {
border: 1px solid black;
}
.highslide-controls {
width: 90px !important;
}
.highslide-controls .highslide-close {
display: none;
}
.highslide-caption {
padding: .5em 0;
}
</style>
';}
        	if ( $Settings->gallery == 'gallery-vertical-strip' ) {
        	$cssUrl.= '<style type="text/css">
.highslide-caption {
width: 100%;
text-align: center;
}
.highslide-close {
display: none !important;
}
.highslide-number {
display: inline;
padding-right: 1em;
color: white;
}
</style>
';}
		}
        echo $cssUrl;
    }

    /**
     * 底部脚本
     *
     * @access public
     * @param unknown $footlink
     * @return unknown
     */
    public static function footlink($links) {
        $Settings = Helper::options()->plugin('HighSlide');
        $Archive = Typecho_Widget::widget('Widget_Archive');
        $HighSlide_ul = Helper::options()->pluginUrl .'/HighSlide/';
        $links= '
		<script type="text/javascript" src="'.$HighSlide_ul.'highslide.js"></script>';
        $links.= '
        <script type="text/javascript">
		//<![CDATA[
        hs.graphicsDir = "'.$HighSlide_ul.'graphics/";';
        $links.='
        hs.showCredits = false;
        hs.fadeInOut = true;';
        if ( $Settings->lang == 'true' ) {
        $links.= '
        hs.lang={
        loadingText : "图片加载中...",
        loadingTitle : "正在加载图片",
        closeText : "关闭",
        closeTitle : "关闭 (Esc)",
        previousText :    "上一张",
        previousTitle :   "上一张 (←键)",
        nextText :        "下一张",
        nextTitle :       "下一张 (→键)",
        moveTitle :       "移动",
        moveText :        "移动图片",
        playText :        "播放",
        playTitle :       "幻灯播放 (空格键)",
        pauseText :       "暂停",
        pauseTitle :      "幻灯暂停 (空格键)",
        number :          "第%1张 共%2张",
        restoreTitle :    "点击可关闭或拖动. 用左右方向键可查看上一张和下一张",
        fullExpandTitle : "查看原图",
        fullExpandText :  "原图"
        };';
        }
        if ( $Settings->auto == 'true' ) {
        $links.= '
        hs.Expander.prototype.onMouseOut = function (sender) {
        sender.close();
        };
        hs.Expander.prototype.onAfterExpand = function (sender) {
        if (!sender.mouseIsOver) sender.close();
         }';
        }
        //非页面定制样式输出
        if ( $Archive->is('index') || $Archive->is('post') || $Archive->is('archive') ) { 
        $links.=  '
        hs.transitions = ["'.$Settings->trans.'","crossfade"];';
        if ( $Settings->outline !== '' ) {
        $links.= '
        hs.outlineType = "'.$Settings->outline.'";';
        }
        if ( $Settings->wrap !== NULL ) {
        $links.= '
        hs.wrapperClassName = "'.implode(" ", $Settings->wrap).'";';
        }
        if ( $Settings->capt !== '' ) {
        $links.= '
        hs.captionEval = "'.$Settings->capt.'";';
        }
        if ( $Settings->cpos !== '' ) {
        $links.= '
        hs.numberPosition = "'.$Settings->cpos.'";';
        }
        if ( $Settings->opac !== '' ) {
        $links.=  '
        hs.dimmingOpacity = '.$Settings->opac.';';
        }
        if ( $Settings->align == 'true' ) {
        $links.=  '
        hs.align = "center";';
        }
        if ( $Settings->slide == 'true' ) {
        $links.=  '
        if (hs.addSlideshow) hs.addSlideshow({
        slideshowGroup: "images",
        interval: 5000,
        repeat: true,
        useControls: true,
        fixedControls: "fit",
        overlayOptions: {
		opacity: .65,
		position: "bottom center",
		hideOnMouseOut: true
        }
        });';
        }
        if ( $Settings->butn == 'true' ) {
        $links.= '
        hs.registerOverlay({
		html: "<div class=\"closebutton\" onclick=\"return hs.close(this)\" title=\"Close\"></div>",
		position: "top right",
		fade: 2
		});';
        }
        }
        //页面相册套装样式输出
        elseif ( $Archive->is('page') ) { 
        $links.='
        hs.transitions = ["expand", "crossfade"];
        if (hs.addSlideshow) hs.addSlideshow({
        interval: 5000,
        repeat: true,
        useControls: true,';
        //连环画册
        if ( $Settings->gallery == 'gallery-horizontal-strip' ) {
        $links.='
        slideshowGroup: ["group1","group2","group3","group4","group5"],
        overlayOptions: {
		className: "text-controls",
		position: "bottom center",
		relativeTo: "viewport",
		offsetY: -60
        },
        thumbstrip: {
		position: "bottom center",
		mode: "horizontal",
		relativeTo: "viewport"
        }
        });
        hs.align = "center";
        hs.dimmingOpacity = 0.8;
        hs.outlineType = "rounded-white";
        hs.captionEval = "this.thumb.alt";
        hs.marginBottom = 105;
        hs.numberPosition = "caption";';
        }
        //黑色影夹
        if ( $Settings->gallery == 'gallery-thumbstrip-above' ) {
        $links.='
        slideshowGroup: ["group1","group2","group3","group4","group5"],
        fixedControls: "fit",
        overlayOptions: {
		position: "bottom center",
		opacity: .75,
		hideOnMouseOut: true
	    },
        thumbstrip: {
		position: "above",
		mode: "horizontal",
		relativeTo: "expander"
        }
        });
        hs.align = "center";
        hs.outlineType = "glossy-dark";
        hs.wrapperClassName = "dark";
        hs.captionEval = "this.a.title";
        hs.numberPosition = "caption";
        hs.useBox = true;
        hs.width = 600;
        hs.height = 400;';
        }
        //幻影橱窗
        if ( $Settings->gallery == 'gallery-in-page' ) {
        $links.='
        overlayOptions: {
		position: "bottom right",
		offsetY: 50
        },
        thumbstrip: {
		position: "above",
		mode: "horizontal",
		relativeTo: "expander"
        }
        });
        hs.restoreCursor = null;
        hs.lang.restoreTitle = "点击查看下一张";
        var inPageOptions = {
        slideshowGroup: ["group1","group2","group3","group4","group5"],
        outlineType: null,
        allowSizeReduction: false,
        wrapperClassName: "in-page controls-in-heading",
        thumbnailId: "gallery-area",
        useBox: true,
        width: 600,
        height: 400,
        targetX: "gallery-area 10px",
        targetY: "gallery-area",
        captionEval: "this.a.title",
        numberPosition: "caption"
        }
        hs.addEventListener(window, "load", function() {
        document.getElementById("thumb1").onclick();
        });
        hs.Expander.prototype.onImageClick = function() {
        if (/in-page/.test(this.wrapper.className))	return hs.next();
        }
        hs.Expander.prototype.onBeforeClose = function() {
        if (/in-page/.test(this.wrapper.className))	return false;
        }
        hs.Expander.prototype.onDrag = function() {
        if (/in-page/.test(this.wrapper.className))	return false;
        }
        hs.addEventListener(window, "resize", function() {
        var i, exp;
        hs.getPageSize();
        for (i = 0; i < hs.expanders.length; i++) {
		exp = hs.expanders[i];
		if (exp) {
			var x = exp.x,
				y = exp.y;
			exp.tpos = hs.getPosition(exp.el);
			x.calcThumb();
			y.calcThumb();
		 	x.pos = x.tpos - x.cb + x.tb;
			x.scroll = hs.page.scrollLeft;
			x.clientSize = hs.page.width;
			y.pos = y.tpos - y.cb + y.tb;
			y.scroll = hs.page.scrollTop;
			y.clientSize = hs.page.height;
			exp.justify(x, true);
			exp.justify(y, true);
			exp.moveTo(x.pos, y.pos);
		}
		}
		});';
        }
        //时光胶带
        if ( $Settings->gallery == 'gallery-vertical-strip' ) {
        $links.='
        slideshowGroup: ["group1","group2","group3","group4","group5"],
		overlayOptions: {
			className: "text-controls",
			position: "bottom center",
			relativeTo: "viewport",
			offsetX: 50,
			offsetY: -5
		},
		thumbstrip: {
			position: "middle left",
			mode: "vertical",
			relativeTo: "viewport"
		}
		});
		hs.registerOverlay({
		html: \'<div class="closebutton" onclick="return hs.close(this)" title="Close"></div>\',
		position: "top right",
		fade: 2
		});
		hs.align = "center";
		hs.dimmingOpacity = 0.8;
		hs.wrapperClassName = "borderless floating-caption";
		hs.captionEval = "this.thumb.alt";
		hs.marginLeft = 100;
		hs.marginBottom = 80;
		hs.numberPosition = "caption";
		hs.lang.number = "%1/%2";';
        }
        //白色相框
        if ( $Settings->gallery == 'gallery-in-box' ) {
        $links.='
        slideshowGroup: ["group1","group2","group3","group4","group5"],
		fixedControls: "fit",
		overlayOptions: {
			opacity: 1,
			position: "bottom center",
			hideOnMouseOut: true
		}
		});
		hs.align = "center";
		hs.outlineType = "rounded-white";
		hs.dimmingOpacity = 0.75;
		hs.useBox = true;
		hs.width = 640;
		hs.height = 480;';
        }
        //记忆片段
        if ( $Settings->gallery == 'gallery-floating-thumbs' ) {
        $links.='
        slideshowGroup: ["group1","group2","group3","group4","group5"],
		fixedControls: "fit",
		overlayOptions: {
			position: "top right",
			offsetX: 200,
			offsetY: -65
		},
		thumbstrip: {
			position: "rightpanel",
			mode: "float",
			relativeTo: "expander",
			width: "210px"
		}
        });
        hs.align = "center";
        hs.outlineType = "rounded-white";
        hs.headingEval = "this.a.title";
        hs.numberPosition = "heading";
        hs.useBox = true;
        hs.width = 600;
        hs.height = 400;';
        }
        //幕布投影
        if ( $Settings->gallery == 'gallery-floating-caption' ) {
        $links.='
        slideshowGroup: ["group1","group2","group3","group4","group5"],
		fixedControls: "fit",
		overlayOptions: {
			opacity: .6,
			position: "bottom center",
			hideOnMouseOut: true
		}
		});
		hs.align = "center";
		hs.wrapperClassName = "dark borderless floating-caption";
		hs.dimmingOpacity = .75;
		hs.captionEval = "this.a.title";';
		}
		//岁月名片
		if ( $Settings->gallery == 'gallery-controls-in-heading' ) {
        $links.='
        slideshowGroup: ["group1","group2","group3","group4","group5"],
		fixedControls: false,
		overlayOptions: {
			opacity: 1,
			position: "top right",
			hideOnMouseOut: false
		}
		});
		hs.align = "center";
		hs.outlineType = "rounded-white";
		hs.wrapperClassName = "controls-in-heading";';
		}
        }
        $links.= '
        //]]>
        </script>
        ';
        echo $links;
    }

    /**
     * 相册标签替换 (分着写了表笑话...请高手指教多维遍历*~*)
     *
     * @access public
     * @param string $code
     * @return void
     */

    public static function gallerycodes1($value, $widget, $lastResult) {
        $Settings = Helper::options()->plugin('HighSlide');
    	$value = empty($lastResult) ? $value : $lastResult;
		$container1 = '';
		$tmp1 = '';
		if ( $widget instanceof Widget_Archive ) {
			//获取
			if ( strchr($value['text'], '[GALLERY-1]') ) {
				if( empty($Settings->gallery1) || false == strchr($Settings->gallery1, ';') ) {
					return $value;
				}
			$galleryArray1 = explode("|", $Settings->gallery1,-1);
			$coverSet1 = end(explode("|", $Settings->gallery1));
			//输出
			$coverArray1 = explode(";", $coverSet1);
			//幻影橱窗封面设置
			if ( $Settings->gallery == 'gallery-in-page' ) {
				$cover1 = '<a id="thumb1" class="highslide" href="'.$coverArray1[1].'" title="'.$coverArray1[2].'" onclick="return hs.expand(this, inPageOptions)"><img src="'.$coverArray1[0].'" alt="'.$coverArray1[2].'"/></a>';
			//岁月名片封面设置
			} elseif ( $Settings->gallery == 'gallery-controls-in-heading' ) {
				$cover1 = '<a class="highslide" href="'.$coverArray1[1].'" title="'.$coverArray1[2].'" onclick="return hs.expand(this, {slideshowGroup: \'group1\'})"><img src="'.$coverArray1[0].'" alt="'.$coverArray1[2].'"/></a><div class="highslide-heading">'.$coverArray1[2].'</div>';
			} else {
			$cover1 = '<a class="highslide" href="'.$coverArray1[1].'" title="'.$coverArray1[2].'" onclick="return hs.expand(this, {slideshowGroup: \'group1\'})"><img src="'.$coverArray1[0].'" alt="'.$coverArray1[2].'"/></a>';}
			foreach ($galleryArray1 as $album1) {
			$albumArray1 = explode(";", $album1);
			//幻影橱窗图片设置
			if ( $Settings->gallery == 'gallery-in-page' ) {
				$tmp1 .= '<a class="highslide" href="'.$albumArray1[1].'" title="'.$albumArray1[2].'" onclick="return hs.expand(this, inPageOptions)"><img src="'.$albumArray1[0].'" alt="'.$albumArray1[2].'"/></a>';
			//岁月名片图片设置
			} elseif ( $Settings->gallery == 'gallery-controls-in-heading' ) {
				$tmp1 .= '<a class="highslide" href="'.$albumArray1[1].'" title="'.$albumArray1[2].'" onclick="return hs.expand(this, {slideshowGroup: \'group1\'})"><img src="'.$albumArray1[0].'" alt="'.$albumArray1[2].'"/></a><div class="highslide-heading">'.$albumArray1[2].'</div>';
				$container1 = '<div class="hidden-container">'.$tmp1.'</div>';
			} else {
				$tmp1 .= '<a class="highslide" href="'.$albumArray1[1].'" title="'.$albumArray1[2].'" onclick="return hs.expand(this, {slideshowGroup: \'group1\'})"><img src="'.$albumArray1[0].'" alt="'.$albumArray1[2].'"/></a>';
				$container1 = '<div class="hidden-container">'.$tmp1.'</div>';}
			}
			//幻影橱窗相册设置
			if ( $Settings->gallery == 'gallery-in-page' ) {
				$output1 = '<div id="gallery-area" style="width: 620px; height: 520px; margin: 0 auto;"><div class="hidden-container">'.$cover1.$tmp1.'</div></div>';
			} else {
			$output1 = '<div class="highslide-gallery">'.$cover1.$container1.'</div>';}
			//替换
			$value['text'] = preg_replace("'\[GALLERY-1\]'i", $output1, $value['text']);
			}
			}
		return $value;
 		}

    public static function gallerycodes2($value, $widget, $lastResult) {
        $Settings = Helper::options()->plugin('HighSlide');
    	$value = empty($lastResult) ? $value : $lastResult;
		$container2 = '';
		$tmp2 = '';
		if ( $widget instanceof Widget_Archive ) {
			if ( strchr($value['text'], '[GALLERY-2]') ) {
				if( empty($Settings->gallery2) || false == strchr($Settings->gallery2, ';') ) {
					return $value;
				}
			$galleryArray2 = explode("|", $Settings->gallery2,-1);
			$coverSet2 = end(explode("|", $Settings->gallery2));
			$coverArray2 = explode(";", $coverSet2);
			if ( $Settings->gallery == 'gallery-in-page' ) {
				$cover2 = '<a id="thumb2" class="highslide" href="'.$coverArray2[1].'" title="'.$coverArray2[2].'" onclick="return hs.expand(this, inPageOptions)"><img src="'.$coverArray2[0].'" alt="'.$coverArray2[2].'"/></a>';
			} elseif ( $Settings->gallery == 'gallery-controls-in-heading' ) {
				$cover2 = '<a class="highslide" href="'.$coverArray2[1].'" title="'.$coverArray2[2].'" onclick="return hs.expand(this, {slideshowGroup: \'group2\'})"><img src="'.$coverArray2[0].'" alt="'.$coverArray2[2].'"/></a><div class="highslide-heading">'.$coverArray2[2].'</div>';
			} else {
			$cover2 = '<a class="highslide" href="'.$coverArray2[1].'" title="'.$coverArray2[2].'" onclick="return hs.expand(this, {slideshowGroup: \'group2\'})"><img src="'.$coverArray2[0].'" alt="'.$coverArray2[2].'"/></a>';}
			foreach ($galleryArray2 as $album2) {
			$albumArray2 = explode(";", $album2);
			if ( $Settings->gallery == 'gallery-in-page' ) {
				$tmp2 .= '<a class="highslide" href="'.$albumArray2[1].'" title="'.$albumArray2[2].'" onclick="return hs.expand(this, inPageOptions)"><img src="'.$albumArray2[0].'" alt="'.$albumArray2[2].'"/></a>';
			} elseif ( $Settings->gallery == 'gallery-controls-in-heading' ) {
				$tmp2 .= '<a class="highslide" href="'.$albumArray2[1].'" title="'.$albumArray2[2].'" onclick="return hs.expand(this, {slideshowGroup: \'group2\'})"><img src="'.$albumArray2[0].'" alt="'.$albumArray2[2].'"/></a><div class="highslide-heading">'.$albumArray2[2].'</div>';
				$container2 = '<div class="hidden-container">'.$tmp2.'</div>';
			} else {
				$tmp2 .= '<a class="highslide" href="'.$albumArray2[1].'" title="'.$albumArray2[2].'" onclick="return hs.expand(this, {slideshowGroup: \'group2\'})"><img src="'.$albumArray2[0].'" alt="'.$albumArray2[2].'"/></a>';
				$container2 = '<div class="hidden-container">'.$tmp2.'</div>';}
			}
			if ( $Settings->gallery == 'gallery-in-page' ) {
				$output2 = '<div id="gallery-area" style="width: 620px; height: 520px; margin: 0 auto;"><div class="hidden-container">'.$cover2.$tmp2.'</div></div>';
			} else {
			$output2 = '<div class="highslide-gallery">'.$cover2.$container2.'</div>';}
			$value['text'] = preg_replace("'\[GALLERY-2\]'i", $output2, $value['text']);
			}
			}
		return $value;
 		}

    public static function gallerycodes3($value, $widget, $lastResult) {
        $Settings = Helper::options()->plugin('HighSlide');
    	$value = empty($lastResult) ? $value : $lastResult;
		$container3 = '';
		$tmp3 = '';
		if ( $widget instanceof Widget_Archive ) {
			if ( strchr($value['text'], '[GALLERY-3]') ) {
				if( empty($Settings->gallery3) || false == strchr($Settings->gallery3, ';') ) {
					return $value;
				}
			$galleryArray3 = explode("|", $Settings->gallery3,-1);
			$coverSet3 = end(explode("|", $Settings->gallery3));
			$coverArray3 = explode(";", $coverSet3);
			if ( $Settings->gallery == 'gallery-in-page' ) {
				$cover3 = '<a id="thumb3" class="highslide" href="'.$coverArray3[1].'" title="'.$coverArray3[2].'" onclick="return hs.expand(this, inPageOptions)"><img src="'.$coverArray3[0].'" alt="'.$coverArray3[2].'"/></a>';
			} elseif ( $Settings->gallery == 'gallery-controls-in-heading' ) {
				$cover3 = '<a class="highslide" href="'.$coverArray3[1].'" title="'.$coverArray3[2].'" onclick="return hs.expand(this, {slideshowGroup: \'group3\'})"><img src="'.$coverArray3[0].'" alt="'.$coverArray3[2].'"/></a><div class="highslide-heading">'.$coverArray3[2].'</div>';
			} else {
			$cover3 = '<a class="highslide" href="'.$coverArray3[1].'" title="'.$coverArray3[2].'" onclick="return hs.expand(this, {slideshowGroup: \'group3\'})"><img src="'.$coverArray3[0].'" alt="'.$coverArray3[2].'"/></a>';}
			foreach ($galleryArray3 as $album3) {
			$albumArray3 = explode(";", $album3);
			if ( $Settings->gallery == 'gallery-in-page' ) {
				$tmp3 .= '<a class="highslide" href="'.$albumArray3[1].'" title="'.$albumArray3[2].'" onclick="return hs.expand(this, inPageOptions)"><img src="'.$albumArray3[0].'" alt="'.$albumArray3[2].'"/></a>';
			} elseif ( $Settings->gallery == 'gallery-controls-in-heading' ) {
				$tmp3 .= '<a class="highslide" href="'.$albumArray3[1].'" title="'.$albumArray3[2].'" onclick="return hs.expand(this, {slideshowGroup: \'group3\'})"><img src="'.$albumArray3[0].'" alt="'.$albumArray3[2].'"/></a><div class="highslide-heading">'.$albumArray3[2].'</div>';
				$container3 = '<div class="hidden-container">'.$tmp3.'</div>';
			} else {
				$tmp3 .= '<a class="highslide" href="'.$albumArray3[1].'" title="'.$albumArray3[2].'" onclick="return hs.expand(this, {slideshowGroup: \'group3\'})"><img src="'.$albumArray3[0].'" alt="'.$albumArray3[2].'"/></a>';
				$container3 = '<div class="hidden-container">'.$tmp3.'</div>';}
			}
			if ( $Settings->gallery == 'gallery-in-page' ) {
				$output3 = '<div id="gallery-area" style="width: 620px; height: 520px; margin: 0 auto;"><div class="hidden-container">'.$cover3.$tmp3.'</div></div>';
			} else {
			$output3 = '<div class="highslide-gallery">'.$cover3.$container3.'</div>';}
			$value['text'] = preg_replace("'\[GALLERY-3\]'i", $output3, $value['text']);
			}
			}
		return $value;
 		}

    public static function gallerycodes4($value, $widget, $lastResult) {
        $Settings = Helper::options()->plugin('HighSlide');
    	$value = empty($lastResult) ? $value : $lastResult;
		$container4 = '';
		$tmp4 = '';
		if ( $widget instanceof Widget_Archive ) {
			if ( strchr($value['text'], '[GALLERY-4]') ) {
				if( empty($Settings->gallery4) || false == strchr($Settings->gallery4, ';') ) {
					return $value;
				}
			$galleryArray4 = explode("|", $Settings->gallery4,-1);
			$coverSet4 = end(explode("|", $Settings->gallery4));
			$coverArray4 = explode(";", $coverSet4);
			if ( $Settings->gallery == 'gallery-in-page' ) {
				$cover4 = '<a id="thumb4" class="highslide" href="'.$coverArray4[1].'" title="'.$coverArray4[2].'" onclick="return hs.expand(this, inPageOptions)"><img src="'.$coverArray4[0].'" alt="'.$coverArray4[2].'"/></a>';
			} elseif ( $Settings->gallery == 'gallery-controls-in-heading' ) {
				$cover4 = '<a class="highslide" href="'.$coverArray4[1].'" title="'.$coverArray4[2].'" onclick="return hs.expand(this, {slideshowGroup: \'group4\'})"><img src="'.$coverArray4[0].'" alt="'.$coverArray4[2].'"/></a><div class="highslide-heading">'.$coverArray4[2].'</div>';
			} else {
			$cover4 = '<a class="highslide" href="'.$coverArray4[1].'" title="'.$coverArray4[2].'" onclick="return hs.expand(this, {slideshowGroup: \'group4\'})"><img src="'.$coverArray4[0].'" alt="'.$coverArray4[2].'"/></a>';}
			foreach ($galleryArray4 as $album4) {
			$albumArray4 = explode(";", $album4);
			if ( $Settings->gallery == 'gallery-in-page' ) {
				$tmp4 .= '<a class="highslide" href="'.$albumArray4[1].'" title="'.$albumArray4[2].'" onclick="return hs.expand(this, inPageOptions)"><img src="'.$albumArray4[0].'" alt="'.$albumArray4[2].'"/></a>';
			} elseif ( $Settings->gallery == 'gallery-controls-in-heading' ) {
				$tmp4 .= '<a class="highslide" href="'.$albumArray4[1].'" title="'.$albumArray4[2].'" onclick="return hs.expand(this, {slideshowGroup: \'group4\'})"><img src="'.$albumArray4[0].'" alt="'.$albumArray4[2].'"/></a><div class="highslide-heading">'.$albumArray4[2].'</div>';
				$container4 = '<div class="hidden-container">'.$tmp4.'</div>';
			} else {
				$tmp4 .= '<a class="highslide" href="'.$albumArray4[1].'" title="'.$albumArray4[2].'" onclick="return hs.expand(this, {slideshowGroup: \'group4\'})"><img src="'.$albumArray4[0].'" alt="'.$albumArray4[2].'"/></a>';
				$container1 = '<div class="hidden-container">'.$tmp4.'</div>';}
			}
			if ( $Settings->gallery == 'gallery-in-page' ) {
				$output4 = '<div id="gallery-area" style="width: 620px; height: 520px; margin: 0 auto;"><div class="hidden-container">'.$cover4.$tmp4.'</div></div>';
			} else {
			$output4 = '<div class="highslide-gallery">'.$cover4.$container4.'</div>';}
			$value['text'] = preg_replace("'\[GALLERY-4\]'i", $output4, $value['text']);
			}
			}
		return $value;
 		}

    public static function gallerycodes5($value, $widget, $lastResult) {
        $Settings = Helper::options()->plugin('HighSlide');
    	$value = empty($lastResult) ? $value : $lastResult;
		$container5 = '';
		$tmp5 = '';
		if ( $widget instanceof Widget_Archive ) {
			if ( strchr($value['text'], '[GALLERY-5]') ) {
				if( empty($Settings->gallery5) || false == strchr($Settings->gallery5, ';') ) {
					return $value;
				}
			$galleryArray5 = explode("|", $Settings->gallery5,-1);
			$coverSet5 = end(explode("|", $Settings->gallery5));
			$coverArray5 = explode(";", $coverSet5);
			if ( $Settings->gallery == 'gallery-in-page' ) {
				$cover5 = '<a id="thumb5" class="highslide" href="'.$coverArray5[1].'" title="'.$coverArray5[2].'" onclick="return hs.expand(this, inPageOptions)"><img src="'.$coverArray5[0].'" alt="'.$coverArray5[2].'"/></a>';
			} elseif ( $Settings->gallery == 'gallery-controls-in-heading' ) {
				$cover5 = '<a class="highslide" href="'.$coverArray5[1].'" title="'.$coverArray5[2].'" onclick="return hs.expand(this, {slideshowGroup: \'group5\'})"><img src="'.$coverArray5[0].'" alt="'.$coverArray5[2].'"/></a><div class="highslide-heading">'.$coverArray5[2].'</div>';
			} else {
			$cover5 = '<a class="highslide" href="'.$coverArray5[1].'" title="'.$coverArray5[2].'" onclick="return hs.expand(this, {slideshowGroup: \'group5\'})"><img src="'.$coverArray5[0].'" alt="'.$coverArray5[2].'"/></a>';}
			foreach ($galleryArray5 as $album5) {
			$albumArray5 = explode(";", $album5);
			if ( $Settings->gallery == 'gallery-in-page' ) {
				$tmp5 .= '<a class="highslide" href="'.$albumArray5[1].'" title="'.$albumArray5[2].'" onclick="return hs.expand(this, inPageOptions)"><img src="'.$albumArray5[0].'" alt="'.$albumArray5[2].'"/></a>';
			} elseif ( $Settings->gallery == 'gallery-controls-in-heading' ) {
				$tmp5 .= '<a class="highslide" href="'.$albumArray5[1].'" title="'.$albumArray5[2].'" onclick="return hs.expand(this, {slideshowGroup: \'group5\'})"><img src="'.$albumArray5[0].'" alt="'.$albumArray5[2].'"/></a><div class="highslide-heading">'.$albumArray5[2].'</div>';
				$container5 = '<div class="hidden-container">'.$tmp5.'</div>';
			} else {
				$tmp5 .= '<a class="highslide" href="'.$albumArray5[1].'" title="'.$albumArray5[2].'" onclick="return hs.expand(this, {slideshowGroup: \'group5\'})"><img src="'.$albumArray5[0].'" alt="'.$albumArray5[2].'"/></a>';
				$container5 = '<div class="hidden-container">'.$tmp5.'</div>';}
			}
			if ( $Settings->gallery == 'gallery-in-page' ) {
				$output5 = '<div id="gallery-area" style="width: 620px; height: 520px; margin: 0 auto;"><div class="hidden-container">'.$cover5.$tmp5.'</div></div>';
			} else {
			$output5 = '<div class="highslide-gallery">'.$cover5.$container5.'</div>';}
			$value['text'] = preg_replace("'\[GALLERY-5\]'i", $output5, $value['text']);
			}
			}
		return $value;
 		}
}