<?php
/**
 * 图片或其它文件调用，感谢跑调，感谢膘叔。
 *
 * @package Fimg
 * @author M4
 * @version 2011.10.24
 * @link http://www.m4html.com
 */
class Fimg_Plugin implements Typecho_Plugin_Interface
{
    /**
     * 激活插件方法,如果激活失败,直接抛出异常
     *
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function activate()
    {
    }

    /**
     * 禁用插件方法,如果禁用失败,直接抛出异常
     *
     * @static
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function deactivate(){}

    /**
     * 获取插件配置面板
     *
     * @access public
     * @param Typecho_Widget_Helper_Form $form 配置面板
     * @return void
     */
    public static function config(Typecho_Widget_Helper_Form $form)
    {

        $form->addInput(new Typecho_Widget_Helper_Form_Element_Text('imgurl', NULL, '', _t('默认图片地址')));
        $form->addInput(new Typecho_Widget_Helper_Form_Element_Text('allowimg', NULL, 'jpg,gif,bmp,png', _t('引用图片格式')));
    }

    /**
     * 个人用户的配置面板
     *
     * @access public
     * @param Typecho_Widget_Helper_Form $form
     * @return void
     */
    public static function personalConfig(Typecho_Widget_Helper_Form $form){}

    /**
     * 插件实现方法
     *
     * @access public
     * @return void
     */
    public static function showfimg($cid,$position=0)
    {
        $option = Typecho_Widget::widget('Widget_Options')->plugin('Fimg');
        $db = Typecho_Db::get();
        $rs = $db->fetchRow($db->select('table.contents.text')
        ->from('table.contents')
        ->where('table.contents.type = ?', 'attachment')
        ->where('table.contents.parent= ?', $cid)
        ->order('table.contents.cid', Typecho_Db::SORT_ASC)
        ->limit(1)->offset(max(0,intval($position)-1)));
        $fimg = unserialize($rs['text']);
        $imgtype = explode(",",$option->allowimg );
        if(!in_array ($fimg['type'], $imgtype)) {
        $fimg['path'] = $option->imgurl;
        }
        echo $fimg['path'];
    }
}
